=begin
=娯楽/基本

・娯楽用通貨はコイン（coin）
medalだと小さなメダルや実績と被るため

==更新履歴
  Date     Version Author Comment
==14/12/19 2.0.1   トリス 統合F～I I
==15/09/03 2.0.2   トリス 統合J～U L O

=end

#==============================================================================
# ■ NWConst::Casino
#==============================================================================
module NWConst::Casino
  
  # スロットとポーカーのBGM
  BGM      = RPG::BGM.new("Town3")
  
  # スロットのベット数変更とコイン変動のSE
  BET_SE   = RPG::SE.new("Cursor1")
  COIN_SE  = RPG::SE.new("Coin", 100)
  
  # ポーカー結果表示時の効果音　[ファイル名, ウェイト時間, BGM停止(trueかfalse)]
  #   BGM停止がtrueだと、再生開始時からウェイト終了時までBGMを止める
  # 役なし（通常時スロットでは鳴らない）
  SE_LOSE = ["Down1",         15, false]
  # ワンペア～ツーペア　　　　　　チェリー
  SE_WIN1 = ["mon_fanfale" ,  80, false]
  # スリーカード～フルハウス　　　プラム　ベル
  SE_WIN2 = ["mon_fanfale2", 120, false]
  # フォーカード～ファイブカード　スイカ　ＢＡＲ
  SE_WIN3 = ["mon_fanfale3", 330,  true]
  # ロイヤルストレートフラッシュ　７７７
  SE_WIN4 = ["mon_fanfale4", 750,  true]
  
  # 上記以外の効果音の音量
  VOLUME_POKER_OTHER = 100   # ポーカーの「娯楽/ポーカー改造」101行目以降の効果音
                             # （SOUND_WINとSOUND_LOSEを除く）
  
  # 役による獲得メダルID　[通常時, 戦闘時]
  MEDAL_SLOT  = [2012, 2013]  # スロット　７７７
  MEDAL_POKER = [2014, 2015]  # ポーカー　ロイヤルストレートフラッシュ
  
end

#==============================================================================
# ■ CasinoManager
#==============================================================================
module CasinoManager; end
class << CasinoManager
  #--------------------------------------------------------------------------
  # ● セットアップ
  #--------------------------------------------------------------------------
  def setup(minimum_coin)
    @minimum_coin = minimum_coin
    @bet_num = 0
  end
  #--------------------------------------------------------------------------
  # ● 最大ベットの取得
  #--------------------------------------------------------------------------
  def bet_max
    return 5
  end  
  #--------------------------------------------------------------------------
  # ● 賭け金を増やす
  #--------------------------------------------------------------------------
  def add_bet
    return unless @bet_num < bet_max
    @bet_num += 1
    if over_bet? 
      @bet_num -= 1
    else
      NWConst::Casino::BET_SE.play
    end
  end
  #--------------------------------------------------------------------------
  # ● 賭け金を減らす
  #--------------------------------------------------------------------------
  def sub_bet
    return unless 0 < @bet_num
    @bet_num -= 1
    NWConst::Casino::BET_SE.play
  end
  #--------------------------------------------------------------------------
  # ● ライン数を増やす
  #--------------------------------------------------------------------------
  def add_line
    return unless @bet_num < bet_max
    @bet_num += 1
  end
  #--------------------------------------------------------------------------
  # ● ベット回数の取得
  #--------------------------------------------------------------------------
  def bet_num
    return @bet_num
  end
  #--------------------------------------------------------------------------
  # ● 最低賭け金の取得
  #--------------------------------------------------------------------------
  def minimum_coin
    return @minimum_coin
  end
  #--------------------------------------------------------------------------
  # ● 賭け金の取得
  #--------------------------------------------------------------------------
  def bet_coin
    return @bet_num * @minimum_coin
  end
  #--------------------------------------------------------------------------
  # ● 賭け金が所持コインを上回っている？
  #--------------------------------------------------------------------------
  def over_bet?
    return $game_party.coin < bet_coin
  end
  #--------------------------------------------------------------------------
  # ● メダル獲得
  #--------------------------------------------------------------------------
  def process_medal(type, param, index)
    case type
    when :poker
      $game_library.gain_medal(NWConst::Casino::MEDAL_POKER[index]) if param == 10
    when :slot
      $game_library.gain_medal(param[index]) if param
    end
  end
  #--------------------------------------------------------------------------
  # ● 結果表示の効果音
  #--------------------------------------------------------------------------
  def process_sound(type, param, wait_method)
    case type
    when :poker
      sound = 
        case param
        when 0;     NWConst::Casino::SE_LOSE
        when 1..2;  NWConst::Casino::SE_WIN1
        when 3..6;  NWConst::Casino::SE_WIN2
        when 7..9;  NWConst::Casino::SE_WIN3
        when 10;    NWConst::Casino::SE_WIN4
        end
    when :slot
      sound = param
    end
    if sound
      $game_system.save_bgm if sound[2]
      Audio.bgm_stop if sound[2]
      Audio.se_play("Audio/SE/" + sound[0])
      wait_method.call(sound[1])
      $game_system.replay_bgm if sound[2]
    end
  end
  #--------------------------------------------------------------------------
  # ● 結果処理
  #--------------------------------------------------------------------------
  def slot_result
    hash = {}
    CasinoManager.bet_num.times do |i|
      $game_slot.check_bonus(NWConst::Slot::LINES[i])
      next if $game_slot.result_scale == 0
      hash[$game_slot.result_bonus[0]] ||= []
      hash[$game_slot.result_bonus[0]].push(i)
    end
    result = []
    hash.keys.sort.each do |key|
      result.push(hash[key])
    end
    return result
  end
end

#==============================================================================
# ■ Cache
#==============================================================================
class << Cache
  #--------------------------------------------------------------------------
  # ● カジノ用グラフィックの取得
  #--------------------------------------------------------------------------
  def casino(filename)
    load_bitmap("Graphics/Casino/", filename)
  end
end

#==============================================================================
# ■ Game_Party
#==============================================================================
class Game_Party < Game_Unit
  #--------------------------------------------------------------------------
  # ● 公開インスタンス変数
  #--------------------------------------------------------------------------
  attr_reader   :coin
  #--------------------------------------------------------------------------
  # ○ オブジェクト初期化
  #--------------------------------------------------------------------------
  alias nw_casino_initialize initialize
  def initialize
    nw_casino_initialize
    @coin = 0
  end
  #--------------------------------------------------------------------------
  # ● 所持コインの増加（減少）
  #--------------------------------------------------------------------------
  def gain_coin(amount)
    @coin = [[@coin + amount, 0].max, max_coin].min
  end
  #--------------------------------------------------------------------------
  # ● 所持コインの減少
  #--------------------------------------------------------------------------
  def lose_coin(amount)
    gain_coin(-amount)
  end
  #--------------------------------------------------------------------------
  # ● 所持コインの最大値を取得
  #--------------------------------------------------------------------------
  def max_coin
    return 99999999
  end
end

#==============================================================================
# ■ Window_Coin
#==============================================================================
class Window_Coin < Window_Base
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    super(Graphics.width - window_width, Graphics.height - window_height, window_width, window_height)
    self.z = 200
    @coin  = 0
    @interval = 0
    refresh
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ幅の取得
  #--------------------------------------------------------------------------
  def window_width
    return 160
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ高さの取得
  #--------------------------------------------------------------------------
  def window_height
    return fitting_height(2)
  end
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    super
    update_have_coin
  end
  #--------------------------------------------------------------------------
  # ● リフレッシュ
  #--------------------------------------------------------------------------
  def refresh
    contents.clear
    draw_have_coin
    draw_bet_coin
    @coin = $game_party.coin
  end
  #--------------------------------------------------------------------------
  # ● 所持コインの更新処理
  #--------------------------------------------------------------------------
  def update_have_coin
    unless @coin == $game_party.coin
      sub = $game_party.coin - @coin
      @coin += 0 < sub ? [1, sub / 5].max : [-1, sub / 5].min
      rect  = Rect.new(0, 0, contents.width, line_height)      
      contents.clear_rect(rect)
      change_color(system_color)
      draw_text(rect, "Bal.", 0)
      change_color(normal_color)
      draw_text(rect, "#{@coin} cns.", 2)      
      NWConst::Casino::COIN_SE.play if (@interval % 10) == 0
      @interval += 1
    else
      @interval = 0
    end
  end  
  #--------------------------------------------------------------------------
  # ● 所持コインの描画
  #--------------------------------------------------------------------------
  def draw_have_coin
    rect  = Rect.new(0, 0, contents.width, line_height)
    value = $game_party.coin
    change_color(system_color)
    draw_text(rect, "Bal.", 0)
    change_color(normal_color)
    draw_text(rect, "#{value} cns.", 2)
  end  
  #--------------------------------------------------------------------------
  # ● 賭けコインの描画
  #--------------------------------------------------------------------------
  def draw_bet_coin
    rect  = Rect.new(0, line_height, contents.width, line_height)
    value = CasinoManager.bet_coin
    change_color(system_color)
    draw_text(rect, "Bid", 0)
    change_color(normal_color)
    draw_text(rect, "#{value} cns.", 2)
  end  
end

#==============================================================================
# ■ Window_CasinoDesc
#==============================================================================
class Window_CasinoDesc < Window_Base
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    super(0, Graphics.height - window_height, window_width, window_height)
    self.z = 200
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ幅の取得
  #--------------------------------------------------------------------------
  def window_width
    return 480
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウ高さの取得
  #--------------------------------------------------------------------------
  def window_height
    return fitting_height(2)
  end
  #--------------------------------------------------------------------------
  # ● テキスト設定
  #--------------------------------------------------------------------------
  def set_text(text)
    if text != @text
      @text = text
      refresh
    end
  end
  #--------------------------------------------------------------------------
  # ● クリア
  #--------------------------------------------------------------------------
  def clear
    set_text("")
  end
  #--------------------------------------------------------------------------
  # ● リフレッシュ
  #--------------------------------------------------------------------------
  def refresh
    contents.clear
    draw_text_ex(4, 0, @text)
  end
end

#==============================================================================
# ■ Scene_CasinoBase
#==============================================================================
class Scene_CasinoBase < Scene_Base
  #--------------------------------------------------------------------------
  # ● 開始処理
  #--------------------------------------------------------------------------
  def start
    super    
    create_background
    create_all_window
    change_phase(:stand)
  end
  #--------------------------------------------------------------------------
  # ● 終了処理
  #--------------------------------------------------------------------------
  def terminate
    super
    dispose_background
  end
  #--------------------------------------------------------------------------
  # ● フェイズの変更
  #--------------------------------------------------------------------------
  def change_phase(phase)
    @phase = phase
  end
  #--------------------------------------------------------------------------
  # ● 背景の作成
  #--------------------------------------------------------------------------
  def create_background
    @background_sprite = Sprite.new
    @background_sprite.bitmap = Cache.casino("casino_bg")
  end
  #--------------------------------------------------------------------------
  # ● フレーム更新（ウェイト用）
  #--------------------------------------------------------------------------
  def abs_wait(duration)
    duration.times { update_basic }
  end
  #--------------------------------------------------------------------------
  # ● 全ウィンドウの作成
  #--------------------------------------------------------------------------
  def create_all_window
    create_desc_window
    create_coin_window
  end
  #--------------------------------------------------------------------------
  # ● 記述ウィンドウの作成
  #--------------------------------------------------------------------------
  def create_desc_window
    @desc_window = Window_CasinoDesc.new
  end
  #--------------------------------------------------------------------------
  # ● コインウィンドウの作成
  #--------------------------------------------------------------------------
  def create_coin_window
    @coin_window = Window_Coin.new
  end
  #--------------------------------------------------------------------------
  # ● 背景の解放
  #--------------------------------------------------------------------------
  def dispose_background
    @background_sprite.dispose
  end
  #--------------------------------------------------------------------------
  # ● 更新処理
  #--------------------------------------------------------------------------
  def update
    super
    case @phase
    when :stand;  update_stand
    when :play;   update_play
    end
  end
  #--------------------------------------------------------------------------
  # ● 待機時の更新処理
  #--------------------------------------------------------------------------
  def update_stand
    if Input.trigger?(:RIGHT)
      CasinoManager.add_bet
      @coin_window.refresh
    elsif Input.trigger?(:LEFT)
      CasinoManager.sub_bet
      @coin_window.refresh
    end
    return_scene if Input.trigger?(:B)
  end
  #--------------------------------------------------------------------------
  # ● ゲーム中の更新処理
  #--------------------------------------------------------------------------
  def update_play
  end
  #--------------------------------------------------------------------------
  # ● フレーム更新（ウェイト用）
  #--------------------------------------------------------------------------
  def update_for_wait
    update_basic
  end
  #--------------------------------------------------------------------------
  # ● フレーム更新（ウェイト用）
  #--------------------------------------------------------------------------
  def wait(duration)
    update_basic
  end
  #--------------------------------------------------------------------------
  # ● ウェイト
  #--------------------------------------------------------------------------
  def wait(duration)
    duration.times {|i| update_for_wait if i < duration / 2 || !show_fast? }
  end
  #--------------------------------------------------------------------------
  # ● 早送り判定
  #--------------------------------------------------------------------------
  def show_fast?
    Input.press?(:A) || Input.press?(:C)
  end
end

#==============================================================================
# ■ Game_Interpreter
#==============================================================================
class Game_Interpreter
  #--------------------------------------------------------------------------
  # ● スロットシーンの呼び出し
  #--------------------------------------------------------------------------
  def call_slot_scene(bet_scale)
    CasinoManager.setup(bet_scale)
    SceneManager.call(Scene_Slot)
    Fiber.yield
  end
  #--------------------------------------------------------------------------
  # ● ポーカーシーンの呼び出し
  #--------------------------------------------------------------------------
  def call_poker_scene(bet_scale)
    CasinoManager.setup(bet_scale)
    SceneManager.call(Scene_Poker)
    Fiber.yield
  end
end








